\name{fanchart}

\alias{fanchart}

\title{Fanchart plot for objects of class varprd}

\description{
  Time Series plots of VAR forecasts with differently shaded confidence
  regions (fanchart) for each endogenous variable. 
}

\usage{
fanchart(x, colors = NULL, cis = NULL)
}

\arguments{
  \item{x}{An object of class \sQuote{\code{varprd}}; generated by
    \command{predict.varest()}.}
  \item{colors}{Character vector of colors to be used for shading. If
    unset, a color scheme according to \code{heat.map} is used.}
  \item{cis}{A numeric vector of confidence intervals. If unset the
    sequence from 0.1 to 0.9 is used (step size 0.1).}
  \item{\dots}{Currently not used.}
}

\author{Bernhard Pfaff}

\references{
  Britton, E., P.G. Fisher and J.D. Whitley (1998), Inflation Report
  projections: understanding the fan chart, \emph{Bank of England
    Quarterly Bulletin}, February, Bank of England, pages 30-37.
}

\seealso{
  \code{\link{VAR}}, \code{\link{predict.varest}} , \code{\link{plot.varprd}} 
}

\examples{
\dontrun{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
var.2c.prd <- predict(var.2c, n.ahead = 8, ci = 0.95)
fanchart(var.2c.prd)
}
}

\keyword{regression}
\concept{Fanchart}
