\name{plot.varest}

\alias{plot.varest}

\encoding{latin1}

\title{Plot method for objects of class varest}

\description{
  Plots per endogenous variable a diagram of fit, the residuals and
  their ACFs und PACFs for an object with class attribute
  \sQuote{\code{varest}}; generated by \command{VAR()}.
}

\usage{
\method{plot}{varest}(x, ...)
}

\arguments{
  \item{x}{An object of class \sQuote{\code{varest}}; generated by \command{VAR()}}
  \item{\dots}{Currently not used.}
}

\author{Bernhard Pfaff}

\references{
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.  
}

\seealso{
  \code{\link{VAR}}
}

\examples{
\dontrun{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
plot(var.2c)
}
}

\keyword{regression}
