\name{normality}

\alias{normality}

\title{Normality, multivariate skewness and kurtosis test}

\encoding{latin1}

\description{
  This function computes univariate and multivariate Jarque-Bera tests
  and multivariate skewness and kurtosis tests for the residuals of a VAR(p). 
}

\usage{
normality(x)
}

\arguments{
\item{x}{Object of class \sQuote{\code{varest}}; generated by
  \command{VAR()}, or an object of class \sQuote{\code{vec2var}}; generated by
  \command{vec2var()}.
}
  
}
\details{
  Univariate versions of the Jarque-Bera test are applied to the
  residuals of each equation. A multivariate version of this test can be
  computed by using the residuals that are standardized by a Choleski
  decomposition of the variance-covariance matrix for the centered
  residuals. Please note, that in this case the test result is dependant
  upon the ordering of the variables.
}

\value{
  A list of class \sQuote{\code{varcheck}} with the following elements is
  returned:\cr
  
  \item{resid}{A matrix of the residuals.}
  \item{jb.uni}{A list of elements with class attribute
    \sQuote{\code{htest}} containing the univariate Jarque-Bera tests.}
  \item{jb.mul}{A list of elements with class attribute
    \sQuote{\code{htest}}.} containing the mutlivariate Jarque-Bera
  test, the multivariate Skewness and Kurtosis tests.  
}

\author{Bernhard Pfaff}

\references{
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Jarque, C. M. and A. K. Bera (1987), A test for normality of
  observations and regression residuals, \emph{International Statistical
  Review}, \bold{55}: 163-172.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.  
}

\seealso{
  \code{\link{VAR}}, \code{\link{vec2var}}, \code{\link{plot.varcheck}}
}

\examples{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
normality(var.2c)
}

\keyword{regression}
\concept{VAR}
\concept{VECM}
\concept{Vector autoregressive model}
\concept{Jarque-Bera}
\concept{Skewness}
\concept{Kurtosis}
\concept{Normality}


