"fanchart" <-
function(x, colors = NULL, cis = NULL){
  if(!(class(x) == "varprd"))
    stop("\nPlease provide an object of class 'varprd',\ngenerated by predict-method for objects of class 'varest'.\n")
  if(is.null(colors))
    colors <- heat.colors(9)
  if(is.null(cis)){
    cis <- seq(0.1, 0.9, by = 0.1)
  } else {
    if((min(cis) <= 0) || (max(cis) >= 1))
      stop("\nValues of confidence intervals must be in(0, 1).\n")
    if(length(cis) > length(colors))
      stop("\nSize of 'colors' vector must be at least as long as\nsize of 'cis' vector\n")
  }
  n.regions <- length(cis)
  n.ahead <- nrow(x$fcst[[1]])
  K <- ncol(x$endog)
  e.sample <- nrow(x$endog)
  endog <- x$endog
  fcst <- NULL 
  for(j in 1:n.regions){
    fcst[[j]] <- predict(x$model, n.ahead = n.ahead, ci = cis[j])$fcst
  }
  xx <- seq(e.sample, length.out = n.ahead + 1)
  xx <- c(xx, rev(xx))
  op <- par(no.readonly = TRUE)
  for(i in 1 : K){
    ymax <- max(c(fcst[[n.regions]][i][[1]][, 3]), endog[, i])
    ymin <- min(c(fcst[[n.regions]][i][[1]][, 2]), endog[, i])
    yy1 <- c(endog[e.sample, i], fcst[[1]][i][[1]][, 2], rev(c(endog[e.sample, i], fcst[[1]][i][[1]][, 3])))
    plot.ts(c(endog[, i], rep(NA, n.ahead)), main = paste("Fanchart for variable", colnames(endog)[i]), xlab = "", ylab = "", ylim = c(ymin, ymax))
    polygon(xx, yy1, col = colors[1], border = colors[1])
    if(n.regions > 1){
      for(l in 2:n.regions){
        yyu <- c(endog[e.sample, i], fcst[[l]][i][[1]][, 3], rev(c(endog[e.sample, i], fcst[[l-1]][i][[1]][, 3])))
        yyl <- c(endog[e.sample, i], fcst[[l-1]][i][[1]][, 2], rev(c(endog[e.sample, i], fcst[[l]][i][[1]][, 2])))
        polygon(xx, yyu, col = colors[l], border = colors[l])
        polygon(xx, yyl, col = colors[l], border = colors[l])
      }
    }
    if (interactive()){
      cat("\nType <Return> to continue: ")
      readline()
    }
  }
  par(op)
}
