"Phi.varest" <-
function(x, nstep=10, ...){
  if(!(class(x)=="varest")){
    stop("\nPlease provide an object of class 'varest', generated by 'VAR()'.\n")
  }
  nstep <- abs(as.integer(nstep))
  K <- x$K
  p <- x$p
  A <- as.array(Acoef(x))
  if(nstep >= p){
    As <- array(0, dim = c(K, K, nstep + 1))
    for(i in (p + 1):(nstep + 1)){
      As[, , i] <- matrix(0, nrow = K, ncol = K)
    }
  } else {
    As <- array(0, dim = c(K, K, p))
  }
  for(i in 1:p){
    As[, , i] <- A[[i]]
  }  
  Phi <- array(0, dim=c(K, K, nstep + 1))
  Phi[, ,1] <- diag(K)
  Phi[, , 2] <- Phi[, , 1] %*% As[, , 1]
  if (nstep > 1) {
    for (i in 3:(nstep + 1)) {
      tmp1 <- Phi[, , 1] %*% As[, , i-1]
      tmp2 <- matrix(0, nrow = K, ncol = K)
      idx <- (i - 2):1
      for (j in 1:(i - 2)) {
        tmp2 <- tmp2 + Phi[, , j+1] %*% As[, , idx[j]]
      }
      Phi[, , i] <- tmp1 + tmp2
    }
  }
  return(Phi)
}
