\name{vec2var}

\alias{vec2var}

\alias{print.vec2var}

\title{Transform a VECM to VAR in levels}

\encoding{latin1}

\description{
  An object of formal class 'ca.jo' is transformed to a VAR in level
  presentation. 
}

\usage{
vec2var(z, r = 1)
}

\arguments{
  \item{z}{An object of class 'ca.jo' generated by function
    \command{ca.jo()} in package 'urca'.}
  \item{r}{The cointegration rank (default is \code{r=1)}.}
}

\details{
  This function enables the user to transform a vector-error-correction
  model (VECM) into a level-VAR form. The rank of the matrix
  \eqn{\bold{\Pi}} has to be submitted, \emph{i.e.} how many
  cointegration relationships have been determined according to the
  outcome of \command{ca.jo()}.
}

\value{
  A list with class attribute \sQuote{\code{vec2var}} holding the
  following elements:\cr

  \item{deterministic}{The matrix of deterministic coefficients.}
  \item{A}{A list with matrix object(s) containing the coefficients for
    the lagged endogenous variables.}
  \item{p}{The lag-order of the estimated VAR-process.}
  \item{K}{The count of endogenous variables.}
  \item{y}{A dataframe with the endogenous variables in levels.}
  \item{obs}{An integer signifying the count of used observations.}
  \item{totobs}{An integer signifying the total number of observations,
    \emph{i.e} including observations taken as starting values..}
  \item{call}{The \code{call} to \code{vec2var}.}
  \item{vecm}{The supplied object \code{z} of formal class \code{ca.jo}.}
  \item{datamat}{A dataframe with the used dataset.}
  \item{resid}{A matrix with the residuals from the empirical VAR(p).}
  \item{r}{Intefer, the assigned co-integration rank from the call.}
}

\author{Bernhard Pfaff}

\references{
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.
}

\seealso{
  \code{\link[urca]{ca.jo}}, \code{\link{predict}}, \code{\link{irf}},
  \code{\link{fevd}}, \code{\link{Phi}}, \code{\link{Psi}},
  \code{\link{normality.test}}, \code{\link{arch.test}},
  \code{\link{serial.test}}, \code{\link{logLik}}, \code{\link{plot}} 
}

\examples{
library(urca)
data(finland)
sjf <- finland
sjf.vecm <- ca.jo(sjf, ecdet = "none", type = "eigen", K = 2,
spec = "longrun", season = 4)
vec2var(sjf.vecm, r = 2)
}

\keyword{regression}
\concept{VAR}
\concept{Vector autoregressive model}
\concept{VAR}
\concept{VECM}

