% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_cov_lower}
\alias{check_cov_lower}
\title{Check Lower Bound of Covariance Parameters}
\usage{
check_cov_lower(cv, q)
}
\arguments{
\item{cv}{(\code{numeric(2*q+1)}) \cr Covariance vector of SVC model.}

\item{q}{(\code{numeric(1)}) \cr Integer indicating the number of SVCs.}
}
\value{
\code{logical(1)} with \code{TRUE} if all conditions above are
fulfilled.
}
\description{
Ensures that the covariance parameters define a positive definite covariance
matrix. It takes the vector
\eqn{(\rho_1, \sigma^2_1, ..., \rho_q, \sigma^2_q, \tau^2)} and checks if
all \eqn{\rho_k>0}, all \eqn{\sigma_k^2>=0}, and \eqn{\tau^2>0}.
}
\examples{
# first one is true, all other are false
check_cov_lower(c(0.1, 0, 0.2,  1, 0.2), q = 2)
check_cov_lower(c(0  , 0, 0.2,  1, 0.2), q = 2)
check_cov_lower(c(0.1, 0, 0.2,  1, 0  ), q = 2)
check_cov_lower(c(0.1, 0, 0.2, -1, 0  ), q = 2)
}
