% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_rep.R
\name{replicate.slope}
\alias{replicate.slope}
\title{Compares and combines slope coefficients in original and follow-up studies}
\usage{
replicate.slope(alpha, b1, se1, n1, b2, se2, n2, s)
}
\arguments{
\item{alpha}{alpha level for 1-alpha or 1 - 2alpha confidence}

\item{b1}{sample slope in original study}

\item{se1}{standard error of slope in original study}

\item{n1}{sample size in original study}

\item{b2}{sample slope in follow-up study}

\item{se2}{standard error of slope in follow-up study}

\item{n2}{sample size in follow-up study}

\item{s}{number of predictor variables in model}
}
\value{
A 4-row matrix. The rows are:
\itemize{
\item Row 1 summarizes the original study
\item Row 2 summarizes the follow-up study
\item Row 3 estimates the difference in slopes
\item Row 4 estimates the average slope
}

The columns are:
\itemize{
\item Estimate - slope estimate (single study, difference, average)
\item SE - standard error
\item t - t-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
\item df - degrees of freedom
}
}
\description{
This function computes confidence intervals for a slope from the original and
follow-up studies, the difference in slopes, and the average of the slopes.
Equality of error variances across studies is not assumed. The confidence
interval for the difference uses a 1 - 2*alpha confidence level, which is
recommended for equivalence testing. Use the \link[vcmeta]{replicate.gen}
function for slopes in other types of models (e.g., binary logistic, ordinal
logistic, SEM).
}
\examples{
replicate.slope(.05, 23.4, 5.16, 50, 18.5, 4.48, 90, 4)

# Should return: 
#                       Estimate       SE         t            p
# Original:                23.40 5.160000 4.5348837 4.250869e-05
# Follow-up:               18.50 4.480000 4.1294643 8.465891e-05
# Original - Follow-up:     4.90 6.833447 0.7170612 4.749075e-01
# Average:                 20.95 3.416724 6.1316052 1.504129e-08
#                              LL       UL       df
# Original:             13.007227 33.79277  45.0000
# Follow-up:             9.592560 27.40744  85.0000
# Original - Follow-up: -6.438743 16.23874 106.4035
# Average:              14.176310 27.72369 106.4035


}
\references{
\insertRef{Bonett2021}{vcmeta}
}
