% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim.R
\name{dims}
\alias{dims}
\alias{vec_empty}
\alias{vec_dim}
\alias{vec_dims}
\title{Vector dimensions}
\usage{
vec_empty(x)

vec_dim(x)

vec_dims(x)
}
\arguments{
\item{x}{A vector}
}
\description{
\itemize{
\item \code{vec_empty()} returns \code{TRUE} if \code{vec_size()} is zero.
\item \code{vec_dims()} gives the dimensionality (i.e. number of dimensions)
\item \code{vec_dim()} returns the size of each dimension
}
}
\details{
Unlike base R, we treat vectors with \code{NULL} dimensions as 1d. This
simplifies the type system by eliding a special case. Compared to base R
equivalent, \code{vec_dim()} returns \code{length()}, not \code{NULL}, when \code{x} is 1d.
}
\examples{
# Compared to base R
x <- 1:5
dim(x)
vec_dim(x)
}
