% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_collection.R
\name{check_time_series_collection}
\alias{check_time_series_collection}
\title{Check that a collection of time series is properly formatted}
\usage{
check_time_series_collection(collection)
}
\arguments{
\item{collection}{a list representing a collection of time series as
described in \code{\link[=plot_collection]{plot_collection()}}.}
}
\value{
a character string with value \code{"OK"} if the object is properly
formatted. Otherwise, the character string indicates the first error found
in the object's format.
}
\description{
This function checks that an object holding a collection of time series,
their future values and their forecasts has the correct format. This kind of
objects are used in function \code{\link[=plot_collection]{plot_collection()}}. A collection of time series
should be a list compounded of objects of class \code{ts_info}, which are built
using the \code{\link[=ts_info]{ts_info()}} function.
}
\examples{
c <- list(ts_info(USAccDeaths), ts_info(ldeaths))
check_time_series_collection(c)
}
