% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.BW.R
\name{scaling.BW}
\alias{scaling.BW}
\title{Scaling factor between two matrices}
\usage{
scaling.BW(S1, S2, method = 0, pa = 0)
}
\arguments{
\item{S1}{a variance-covariance matrix}

\item{S2}{a variance-covariance matrix}

\item{method}{an integer for the method of matrix inversion (see function 'minv')}

\item{pa}{an integer for the parameter of matrix inversion (see function 'minv')}
}
\value{
The scaling factor between the two matrices.
}
\description{
Computes the maximum-likelihood estimate
of the scaling factor between two proportional covariance matrices.
Note that the scaling factor between the two matrices
is equal to the arithmetic mean of their relative eigenvalues.
}
\examples{

# Data matrix of 2D landmark coordinates
data("Tropheus")
PHEN <- as.matrix(Tropheus[which(names(Tropheus) == "X1"):which(names(Tropheus) == "Y19")])

# Procrustes superimposition
library("geomorph")
PHEN_array <- arrayspecs(PHEN, p = 19, k = 2)
phen.gpa <- gpagen(PHEN_array, print.progress = FALSE)
proc.coord <- two.d.array(phen.gpa$coords)

# Between-group (B) and within-group (W) covariance matrices for all populations
B <- cov.B(proc.coord, groups = Tropheus$POP.ID, sex = Tropheus$Sex)
W <- cov.W(proc.coord, groups = Tropheus$POP.ID, sex = Tropheus$Sex)

# ML estimate of the scaling factor between B and W
sc <- scaling.BW(B, W)

# Scaling of B to W
Bsc <- B / sc

}
\seealso{
See \code{\link{minv}} for the method and the parameter used for the matrix inversion
}
