% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotInfectionRate.R
\name{plotInfectionRate}
\alias{plotInfectionRate}
\title{Plot Infection Rate}
\usage{
plotInfectionRate(InfRtOutput, year)
}
\arguments{
\item{InfRtOutput}{Output from returned `getInfectionRate()`}

\item{year}{Year to plot infection rate on}
}
\value{
ggplot object
}
\description{
plotInfectionRate() plots the output returned from `getInfectionRate()` with confidence intervals using ggplot
}
\examples{
IR = getInfectionRate(sample_pools,
                      interval = "Week",
                      target_disease = "WNV",
                      pt_estimate = "mle", species_list = c("Cx pipiens"),
                      trap_list = c("CO2","GRVD") )
plotInfectionRate(InfRtOutput = IR, year = 2017)
}
