% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getArthroCollections.R
\name{getArthroCollections}
\alias{getArthroCollections}
\title{Get arthropod collections data}
\usage{
getArthroCollections(
  token,
  start_year,
  end_year,
  arthropod,
  agency_ids = NULL,
  spatial_features = NULL
)
}
\arguments{
\item{token}{A valid access token returned from `getToken()`}

\item{start_year}{Start year of data}

\item{end_year}{End year of data}

\item{arthropod}{Specify arthropod type from: 'mosquito', 'tick'}

\item{agency_ids}{Filter on agency id, default to NULL for all available agencies,otherwise provide a vector of agency ids, such as `agency_ids = c(55,56)`}

\item{spatial_features}{Filter data by spatial feature}
}
\value{
A dataframe of collections data
}
\description{
`getArthroCollections()` obtains collections data on a year range [start_year, end_year] for authorized VectorSurv Gateway accounts.
}
\examples{
\dontrun{
token = getToken()
collections = getArthroCollections(token, 2021, 2022, 'mosquito',c(55,56), TRUE)}
}
