% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hot_soak.R
\name{hot_soak}
\alias{hot_soak}
\title{Estimation of average running hot-soak evaporative emissions}
\usage{
hot_soak(x, carb, p, eshotc, eswarmc, eshotfi)
}
\arguments{
\item{x}{Mean number of trips per vehicle per day}

\item{carb}{fraction of gasoline vehicles with carburator or fuel return system}

\item{p}{Fraction of trips finished with hot engine}

\item{eshotc}{average daily hot-soak evaporative factor for vehicles with
carburator or fuel return system}

\item{eswarmc}{average daily cold-warm-soak evaporative factor for vehicles
with carburator or fuel return system}

\item{eshotfi}{average daily hot-soak evaporative factor for vehicles
with fuel injection and returnless fuel systems}
}
\value{
numeric vector of emission estimation in grams
}
\description{
\code{hot_soak} estimates of evaporative emissions from EMEP/EEA
emisison guidelines
}
\examples{
\dontrun{
# Do not run
ev <- hot_soak(x = 1:10, carb = 0, p = 1, eshot = 1, eswarmc =1,
eshotfi = 1)
}
}
\references{
Mellios G and Ntziachristos 2016. Gasoline evaporation. In:
EEA, EMEP. EEA air pollutant emission inventory guidebook-2009. European
Environment Agency, Copenhagen, 2009
}
