% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vein.R
\docType{package}
\name{vein}
\alias{vein}
\alias{vein-package}
\title{vein: a package for elaborating vehicular emissions inventories}
\description{
This package provides functions to arrange traffic data, prepare
emission factors, estimate emissions and process emissions
}
\details{
\strong{1) Inventory}

It is recommended to start with the function \code{\link{inventory}} which
produces a set of directories and scripts to run vein.

\strong{2) Traffic data}

The user must count with traffic data at each street at least for one hour.
The format of the data must be spatial, either "SpatialLinesDataFrame" or
an object class of "sf". Then the user must use any ob tje age functions:
\code{\link{age_ldv}}, \code{\link{age_hdv}}, \code{\link{age_moto}} or
\code{\link{my_age}}. The outputs of these functions can be saved in
directory 'veh' with the extension .rds.

\strong{3) Emission factors}

The user must chosse a type of emission factor: from Copert with the
\code{\link{ef_ldv_speed}} or \code{\link{ef_hdv_speed}}, from local sources
as one constant emission factors by age of use of vehicles with
\code{\link{EmissionFactorsList}} or as a merge between both with
\code{\link{ef_ldv_scaled}} or \code{\link{ef_hdv_scaled}}.

\strong{4) Estimating emissions}

Once all information is obtained, the user can estimate the emissions with
\code{\link{emis}}, \code{\link{emis_cold}} or other.

\strong{5) Processing the emissions}

The function for processing the emissions ins \code{\link{emis_post}}.
}
