% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_paved.R
\name{emis_paved}
\alias{emis_paved}
\title{Estimation of resuspension emissions from paved roads}
\usage{
emis_paved(
  veh,
  adt,
  lkm,
  k = 0.62,
  sL1 = 0.6,
  sL2 = 0.2,
  sL3 = 0.06,
  sL4 = 0.03,
  W,
  net = net
)
}
\arguments{
\item{veh}{Numeric vector with length of elements equals to number of streets
It is an array with dimenssions number of streets x hours of day x days of week}

\item{adt}{Numeric vector of with Average Daily Traffic (ADT)}

\item{lkm}{Length of each link}

\item{k}{K_PM30 = 3.23 (g/vkm), K_PM15 = 0.77 (g/vkm), K_PM10 = 0.62 (g/vkm)
and K_PM2.5 = 0.15  (g/vkm).}

\item{sL1}{Silt loading (g/m2) for roads with ADT <= 500}

\item{sL2}{Silt loading (g/m2) for roads with ADT > 500 and <= 5000}

\item{sL3}{Silt loading (g/m2) for roads with ADT > 5000 and <= 1000}

\item{sL4}{Silt loading (g/m2) for roads with ADT > 10000}

\item{W}{array of dimensions of veh. It consists in the hourly averaged
weight of traffic fleet in each road}

\item{net}{SpatialLinesDataFrame or Spatial Feature of "LINESTRING"}
}
\value{
emission estimation  g/h
}
\description{
\code{emis_paved} estimates vehicular emissions from paved roads.
The vehicular emissions are estimated as the product of the vehicles on a
road, length of the road, emission factor from AP42 13.2.1 Paved roads.
It is assumed dry hours and anual aggregation should consider moisture factor.
It depends on Average Daily Traffic (ADT)
}
\note{
silt values can vary a lot. For comparison:

\tabular{lcc}{
  ADT         \tab US-EPA g/m2  \tab  CENMA (Chile) g/m2 \cr
  < 500       \tab 0.6           \tab  2.4   \cr
  500-5000    \tab 0.2           \tab  0.7   \cr
  5000-1000   \tab 0.06          \tab  0.6   \cr
  >10000      \tab  0.03         \tab  0.3   \cr
}
}
\examples{
\dontrun{
# Do not run
veh <- matrix(1000, nrow = 10,ncol = 10)
W <- veh*1.5
lkm <-  1:10
ADT <-1000:1010
emi  <- emis_paved(veh = veh, adt = ADT, lkm = lkm, k = 0.65, W = W)
class(emi)
head(emi)
}
}
\references{
EPA, 2016. Emission factor documentation for AP-42. Section
13.2.1, Paved Roads. https://www3.epa.gov/ttn/chief/ap42/ch13/final/c13s0201.pdf

CENMA Chile: Actualizacion de inventario de emisiones de contaminntes atmosfericos RM 2020
Universidad de Chile#'
}
