% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_start_time.R
\name{use_start_time}
\alias{use_start_time}
\alias{use_start_time.default}
\alias{use_start_time.embed_channel9}
\alias{use_start_time.embed_vimeo}
\alias{use_start_time.embed_youtube}
\title{Specify a start time for an embedded video}
\usage{
use_start_time(...)

\method{use_start_time}{default}(...)

\method{use_start_time}{embed_youtube}(embed, start_time, ...)

\method{use_start_time}{embed_vimeo}(embed, start_time, ...)

\method{use_start_time}{embed_channel9}(embed, start_time, is_paused = TRUE,
  ...)
}
\arguments{
\item{...}{generic args to pass through}

\item{embed}{embed object, i.e. \code{\link{embed_youtube}}}

\item{start_time}{numeric (seconds), or character ("3m15s")}

\item{is_paused}{logical, for "Channel 9" specifies if the video
should be paused at this time}
}
\description{
Please not that for Vimeo, you may specify a start time, but you can not
specify that the video be paused at this time. In other words, it is like
"autoplay" is set to TRUE, and you cannot unset it.
}
\examples{
  rickroll_youtube() \%>\%
    use_start_time("3m32s")

}

