% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin-read-write.R
\name{vetiver_pin_write}
\alias{vetiver_pin_write}
\alias{vetiver_pin_read}
\title{Read and write a trained model to a board of models}
\usage{
vetiver_pin_write(board, vetiver_model, ..., check_renv = FALSE)

vetiver_pin_read(board, name, version = NULL, check_renv = FALSE)
}
\arguments{
\item{board}{A pin board, created by \code{\link[pins:board_folder]{board_folder()}}, \code{\link[pins:board_connect]{board_connect()}},
\code{\link[pins:board_url]{board_url()}} or another \code{board_} function.}

\item{vetiver_model}{A deployable \code{\link[=vetiver_model]{vetiver_model()}} object}

\item{...}{Additional arguments passed on to methods for a specific board.}

\item{check_renv}{Use \href{https://rstudio.github.io/renv/}{renv} to record the
packages used at training time with \code{vetiver_pin_write()} and check for
differences with \code{vetiver_pin_read()}. Defaults to \code{FALSE}.}

\item{name}{Pin name.}

\item{version}{Retrieve a specific version of a pin. Use \code{\link[pins:pin_versions]{pin_versions()}} to
find out which versions are available and when they were created.}
}
\value{
\code{vetiver_pin_read()} returns a \code{\link[=vetiver_model]{vetiver_model()}}; \code{vetiver_pin_write()}
returns the name of the new pin, invisibly.
}
\description{
Use \code{vetiver_pin_write()} to pin a trained model to a board of models,
along with an input prototype for new data and other model metadata. Use
\code{vetiver_pin_read()} to retrieve that pinned object.
}
\details{
These functions read and write a \code{\link[=vetiver_model]{vetiver_model()}} pin on the
specified \code{board} containing the model object itself and other elements
needed for prediction, such as the model's input data prototype or which
packages are needed at prediction time. You may use \code{\link[pins:pin_read]{pins::pin_read()}} or
\code{\link[pins:pin_meta]{pins::pin_meta()}} to handle the pin, but \code{vetiver_pin_read()} returns a
\code{\link[=vetiver_model]{vetiver_model()}} object ready for deployment.
}
\examples{
library(pins)
model_board <- board_temp()

cars_lm <- lm(mpg ~ ., data = mtcars)
v <- vetiver_model(cars_lm, "cars_linear")
vetiver_pin_write(model_board, v)
model_board

vetiver_pin_read(model_board, "cars_linear")

# can use `version` argument to read a specific version:
pin_versions(model_board, "cars_linear")
\dontshow{if (interactive() || identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# can store an renv lockfile as part of the pin:
vetiver_pin_write(model_board, v, check_renv = TRUE)
\dontshow{\}) # examplesIf}
}
