% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settings.R
\name{vetr_settings}
\alias{vetr_settings}
\title{Generate Control Settings For vetr and alike}
\usage{
vetr_settings(type.mode = 0L, attr.mode = 0L, lang.mode = 0L,
  fun.mode = 0L, rec.mode = 0L, suppress.warnings = FALSE,
  fuzzy.int.max.len = 100L, width = -1L, env.depth.max = 65535L,
  symb.sub.depth.max = 65535L, symb.size.max = 15000L, nchar.max = 65535L,
  track.hash.content.size = 63L, env = NULL)
}
\arguments{
\item{type.mode}{integer(1L) in 0:2, defaults to 0, determines how object
types (as in \code{typeof}) are compared: \itemize{
\item 0: integer like numerics (e.g. \code{1.0}) can match against
integer templates, and integers always match real templates; all
function types are considered of the same type
\item 1: integers always match against numeric templates, but not vice
versa, and integer-like numerics are treated only as numerics;
functions only match same function type (i.e. closures only match
closures, builtins builtins, and specials specials)
\item 2: types must be equal for all objects types (for functions, this
is unchanged from 1)
}}

\item{attr.mode}{integer(1L) in 0:2, defaults to 0,  determines strictness of
attribute comparison: \itemize{
\item \code{0} only checks attributes that are present in target, and
uses special comparisons for the special attributes (\code{class},
\code{dim}, \code{dimnames}, \code{names}, \code{row.names},
\code{levels}, \code{srcref}, and \code{tsp}) while requiring other
attributes to be \code{alike}
\item \code{1} is like \code{0}, except all atributes must be
\code{alike}
\item \code{2} requires all attributes to be present in \code{target} and
\code{current} and to be alike
}}

\item{lang.mode}{integer(1L) in 0:1, defaults to 0, controls language
matching, set to \code{1} to turn off use of \code{\link[=match.call]{match.call()}}}

\item{fun.mode}{NOT IMPLEMENTED, controls how functions are compared}

\item{rec.mode}{integer(1L) \code{0} currently unused, intended to control how
recursive structures (other than language objects) are compared}

\item{suppress.warnings}{logical(1L) suppress warnings if TRUE}

\item{fuzzy.int.max.len}{max length of numeric vectors to consider for
integer likeness (e.g. \code{c(1, 2)} can be considered "integer", even
though it is numeric); currently we limit this check to vectors
shorter than 100 to avoid a potentially expensive computation on large
vectors, set to -1 to apply to all vectors irrespective of length}

\item{width}{to use when deparsing expressions; default \code{-1}
equivalent to \code{getOption("width")}}

\item{env.depth.max}{integer(1L) maximum number of nested environments to
recurse through, defaults to 65535L; these are tracked to make sure we do
not get into an infinite recursion loop, but because they are tracked we
keep a limit on how many we will go through, set to -1 to allow unlimited
recursion depth.  You should not need to change this unless you are running
into the recursion limit.}

\item{symb.sub.depth.max}{integer(1L) maximum recursion depth when
recursively substituting symbols in vetting expression, defaults to 65535L}

\item{symb.size.max}{integer(1L) maximum number of characters that a symbol
is allowed to have in vetting expressions, defaults to 15000L.}

\item{nchar.max}{integer(1L) defaults to 65535L, threshold after which
strings encountered in C code are truncated.  This is the read limit.  In
theory \code{vetr} can produce strings longer than that by combining multiple
shorter pieces.}

\item{track.hash.content.size}{integer(1L) (advanced) used to set the initial
size of the symbol tracking vector used with the hash table that detects
recursive symbol substitution.  If the tracking vector fills up it will be
grown by 2x.  This parameter is exposed mostly for developer use.}

\item{env}{what environment to use to match calls and evaluate vetting
expressions, although typically you would specify this with the \code{env}
argument to \code{vet}; if NULL will use the calling frame to
\code{vet/vetr/alike}.}
}
\value{
list with all the setting values
}
\description{
Utility function to generate setting values.  We strongly recommend
that you generate the settings outside of function calls so that setting
generation does not become part of the \code{vet/vetr/alike} evaluation as
that could add noticeable overhead to the function evaluation.
}
\details{
Settings after \code{fuzzy.int.max.len} are fairly low level and exposed mostly
for testing purposes.  You should generally not need to use them.

Note that a successful evaluation of this function does not guarantee a
correct settings list.  Those checks are carried out internally by
\code{vet/vetr/alike}.
}
\examples{
type_alike(1L, 1.0, settings=vetr_settings(type.mode=2))
## better if you are going to re-use settings to reduce overhead
set <- vetr_settings(type.mode=2)
type_alike(1L, 1.0, settings=set)
}
\seealso{
\code{\link{type_alike}}, \code{\link{alike}}, \code{\link{vetr}}
}
