% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_functions.R
\name{vglmer_predict}
\alias{vglmer_predict}
\alias{predict.vglmer}
\alias{predict_MAVB}
\title{Predict after vglmer}
\usage{
\method{predict}{vglmer}(
  object,
  newdata,
  samples = 0,
  samples_only = FALSE,
  summary = TRUE,
  allow_missing_levels = FALSE,
  ...
)

predict_MAVB(
  object,
  newdata,
  samples = 0,
  samples_only = FALSE,
  var_px = Inf,
  summary = TRUE,
  allow_missing_levels = FALSE
)
}
\arguments{
\item{object}{Model fit using \code{vglmer}.}

\item{newdata}{Dataset to use for predictions. It cannot be missing.}

\item{samples}{Number of samples to draw. Using \code{0} (default) gives the
expectation of the linear predictor. A positive integer draws
\code{samples} samples from the variational distributions and calculates
the linear predictor.}

\item{samples_only}{Default (\code{FALSE}) returns the samples from the
variational distributions, \bold{not} the prediction. Each row is a sample and
each column is a parameter.}

\item{summary}{Default (\code{TRUE}) returns the mean and variance of the
samples for each observation. \code{FALSE} returns a matrix of the sampled
linear predictor for each observation. Each row is a sample and each column
is an observation.}

\item{allow_missing_levels}{Default (\code{FALSE}) does not allow prediction
for levels not observed in the original data. \code{TRUE} allows for
prediction on unseen levels; the value of \code{0} (with no uncertainty) is
used for the corresponding random effect.}

\item{...}{Not used; included to maintain compatibility with existing
methods.}

\item{var_px}{Variance of working prior for marginal augmentation. Default
(\code{Inf}) is a flat, improper, prior.}
}
\value{
This function returns an estimate of the linear predictor. The
  default returns the expected mean, i.e. \eqn{E_{q(\alpha,\beta)}[x_i^T
  \beta + z_i^T\alpha]}. If \code{samples > 0}, these functions return a
  summary of the prediction for each observation, i.e. the estimated mean and
  variance. If \code{summary = FALSE}, the sampled values of the linear
  predictor are returned as a matrix. \code{predict_MAVB} performs MAVB as
  described in Goplerud (2022a) before returning the linear predictor.
  
  If \code{allow_missing_levels = TRUE}, then observations with a new
  (unseen) level for the random effect are given a value of zero for that
  term of the prediction.
}
\description{
These functions calculate the estimated linear predictor using
  the variational distributions. \code{predict.vglmer} draws predictions
  using the estimated variational distributions; \code{predict_MAVB} does so
  using the MAVB procedure described in Goplerud (2022a).
}
\examples{

set.seed(123)
sim_data <- data.frame(
  x = rnorm(100),
  y = rbinom(100, 1, 0.5),
  g = sample(letters, 100, replace = TRUE)
)

# Run with defaults
est_vglmer <- vglmer(y ~ x + (x | g), data = sim_data, family = "binomial")

# Simple prediction
predict(est_vglmer, newdata = sim_data)
# Return 10 posterior draws of the linear predictor for each observation.
predict_MAVB(est_vglmer, newdata = sim_data, summary = FALSE, samples = 10)
# Predict with a new level; note this would fail if 
# allow_missing_levels = FALSE (the default)
predict(est_vglmer,
  newdata = data.frame(g = "AB", x = 0),
  allow_missing_levels = TRUE
)
}
