% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_feature.R
\name{calculate_feature}
\alias{calculate_feature}
\title{calculate_feature}
\usage{
calculate_feature(viewshed, feature, type, exclude_value)
}
\arguments{
\item{viewshed}{Viewshed object.}

\item{feature}{Raster. Land cover or land use}

\item{type}{Numeric. The input type of land cover raster.
type=1: percentage raster (that represents the percentage of
area in each cell).
type=2: binary raster (that only uses two values to represent whether
the feature exists in each cell).}

\item{exclude_value}{Numeric. the value of those cells need to be excluded
in the analysis. If type = 2, exclude_value is reqired.}
}
\value{
Numeric. The canopy area in the viewshed.
}
\description{
The calculate_feature function is designed to extract specific
feature-related information within a viewshed. It allows you to compute
the proportion of the feature that is present in the viewshed.
}
\examples{
# Load a viewpoint
test_viewpoint <- sf::read_sf(system.file("test_viewpoint.shp", package = "viewscape"))
# load dsm raster
dsm <- terra::rast(system.file("test_dsm.tif", package ="viewscape"))
#Compute viewshed
viewshed <- compute_viewshed(dsm = dsm,
                             viewpoints = test_viewpoint,
                             offset_viewpoint = 6)
# load canopy raster
test_canopy <- terra::rast(system.file("test_canopy.tif",
                                       package ="viewscape"))
# calculate the percentage of canopy coverage
test_canopy_proportion <- viewscape::calculate_feature(viewshed = viewshed,
                                                       feature = test_canopy,
                                                       type = 2,
                                                       exclude_value = 0)
}
