% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_position.R
\name{set_position}
\alias{set_position}
\title{Set animal position elevation}
\usage{
set_position(data, position)
}
\arguments{
\item{data}{@param data LAS class object containing the xyz coordinates of a 3D point
cloud classified as ground and non-ground points.}

\item{position}{vector of length 3 containing the xyz coordinates of the
animal location. Default = c(0,0,0).}
}
\value{
A vector of length 3 containing the updated position.
}
\description{
Updates the elevation of the user defined animal position based on the nearest ground point.
The updated elevation correspond to the user defined elevation + the elevation
of the nearest ground point.
}
\examples{
\donttest{
#- import the tree_line_plot dataset
file <- system.file("extdata", "tree_line_plot.laz", package="viewshed3d")
tls <- lidR::readLAS(file)

center <- c(0,0,2) # defines the scene center for the entire process
angle <- 1 # defines the angular resolution for the entire process

#- remove noise to avoid visibility estimates error
tls_clean <- viewshed3d::denoise_scene(tls,method="sd",
                                       filter=6)


#- class ground and vegetation points
class <- lidR::classify_ground(tls_clean, lidR::csf(rigidness = 1L,
                                                 class_threshold = 0.2,
                                                 sloop_smooth = FALSE))

new_position <- viewshed3d::set_position(class,center)

# input position
center
# updated position
new_position
}
}
