% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_facvar.R
\name{desc_facvar}
\alias{desc_facvar}
\title{Summarise categorical variables}
\usage{
desc_facvar(
  .data,
  vf,
  format = "n_/N_ (pc_\%)",
  digits = 0,
  pad_width = 12,
  ncat_max = 10,
  export_raw_values = FALSE
)
}
\arguments{
\item{.data}{A data.frame, where \code{vf} are column names of categorical variables}

\item{vf}{A character vector}

\item{format}{A character string, formatting options.}

\item{digits}{A numeric. Number of digits for the percentage (passed to interval formatting function).}

\item{pad_width}{A numeric. Minimum character length of value output (passed to \code{stringr::str_pad()}).}

\item{ncat_max}{A numeric. How many levels should be allowed for all variables? See details.}

\item{export_raw_values}{A logical. Should the raw values be exported?}
}
\value{
A data.frame with columns
\itemize{
\item \code{var} the variable name
\item \code{level} the level of the variable
\item \code{value} the formatted value with possible number of cases \code{n_},
number of available cases \code{N_}, and percentage \code{pc_}, depending on
format argument.
\item \code{n_avail} the number of cases with available data
for this variable.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Summarize categorical data and
handle output format.
}
\details{
Many other packages provide tools to summarize data. This one is just
the package author's favorite.
Important \code{format} inputs are
\itemize{
\item \code{n_} number of patients with the categorical variable at said level
\item \code{N_} the first quartile number of patients with an available value for this variable
\item \code{pc_} percentage of n / N
}
The format argument should contain at least the words "n_", "N_",
and optionally "pc_".
\code{ncat_max} ensures that you didn't provided a continuous
variable to \code{\link[=desc_facvar]{desc_facvar()}}. If you have many levels for one of your variables,
set to \code{Inf} or high value.
Equivalent for continuous data is \code{\link[=desc_cont]{desc_cont()}}.
}
\examples{
df1 <-
  data.frame(
    smoke_status = c("smoker", "non-smoker",
           "smoker", "smoker",
           "smoker", "smoker",
           "non-smoker"
           ),
   hypertension = c(1, 1, 0, 1, 1, 1, 1),
    age = c(60, 50, 56, 49, 75, 69, 85),
    bmi = c(18, 30, 25, 22, 23, 21, 22)
  )

# Use default formatting
desc_facvar(.data = df1, vf = c("hypertension", "smoke_status"))

# Use custom formatting
desc_facvar(.data = df1,
           vf = c("hypertension", "smoke_status"),
           format = "n_ out of N_, pc_\%",
           digits = 1)

# You might want to export raw values, to run plotting or
# other formatting functions

desc_facvar(.data = df1,
            vf = c("hypertension", "smoke_status"),
            export_raw_values = TRUE)
}
\seealso{
\code{\link[=desc_cont]{desc_cont()}}
}
