% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/visHierarchicalLayout.R
\name{visHierarchicalLayout}
\alias{visHierarchicalLayout}
\title{Network visualization Hierarchical layout options}
\usage{
visHierarchicalLayout(graph, enabled = TRUE, levelSeparation = NULL,
  direction = NULL, sortMethod = NULL)
}
\arguments{
\item{graph}{: a visNetwork object}

\item{enabled}{: Boolean. Default to TRUE when calling this function.    Enable or disable the hierarchical layout.}

\item{levelSeparation}{: Number. Default to 150.  The distance between the different levels.}

\item{direction}{: String. Default to 'UD'. The direction of the hierarchical layout. The available options are: UD, DU, LR, RL. To simplify: up-down, down-up, left-right, right-left.}

\item{sortMethod}{: String. Default to 'hubsize'.  The algorithm used to ascertain the levels of the nodes based on the data. The possible options are: hubsize, directed.}
}
\description{
Network visualization Hierarchical layout options. For full documentation, have a look at \link{visDocumentation}.
}
\examples{
nodes <- data.frame(id = 1:10)
edges <- data.frame(from = round(runif(8)*10), to = round(runif(8)*10))

visNetwork(nodes, edges) \%>\%
 visHierarchicalLayout()

visNetwork(nodes, edges) \%>\%
 visHierarchicalLayout(direction = "LR")
}
\seealso{
\link{visNodes} for nodes options, \link{visEdges} for edges options, \link{visGroups} for groups options,
\link{visLegend} for adding legend, \link{visOptions} for custom option, \link{visLayout} & \link{visHierarchicalLayout} for layout,
\link{visPhysics} for control physics, \link{visInteraction} for interaction, \link{visNetworkProxy} & \link{visFocus} & \link{visFit} for animation within shiny,
\link{visDocumentation}, \link{visEvents}, \link{visConfigure} ...
}

