% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visTreeModule.R
\name{visNetwork-treeModule}
\alias{visNetwork-treeModule}
\alias{visTreeModuleServer}
\alias{visTreeModuleUI}
\title{Module shiny for visualize and customize a \code{rpart} tree}
\usage{
visTreeModuleServer(input, output, session, data, tooltip_data = NULL,
  tooltipColumns = "", main = "", submain = "", footer = "",
  direction = "UD", fallenLeaves = FALSE, rules = TRUE,
  simplifyRules = TRUE, shapeVar = "dot", shapeY = "square",
  colorVar = NULL, colorY = NULL, colorEdges = "#8181F7",
  nodesFontSize = 16, edgesFontSize = 14, edgesFontAlign = "horizontal",
  legend = TRUE, legendNodesSize = 22, legendFontSize = 16,
  legendWidth = 0.1, legendNcol = 1, legendPosition = "left",
  nodesPopSize = FALSE, minNodeSize = 15, maxNodeSize = 30,
  highlightNearest = list(enabled = TRUE, degree = list(from = 50000, to = 0),
  hover = FALSE, algorithm = "hierarchical"), collapse = list(enabled = TRUE,
  fit = TRUE, resetHighlight = TRUE, clusterOptions = list(fixed = TRUE, physics
  = FALSE)), updateShape = TRUE, tooltipDelay = 500, digits = 3,
  height = 650, width = "100\%", export = TRUE)

visTreeModuleUI(id, rpartParams = TRUE, visTreeParams = TRUE,
  quitButton = FALSE)
}
\arguments{
\item{input}{\code{list} shiny input}

\item{output}{\code{list}, shiny output}

\item{session}{\code{list}, shiny session}

\item{data}{\code{reactive}, a \code{data.frame} or a \code{rpart} result. Must be a reactive object}

\item{tooltip_data}{\code{reactive}, a \code{data.frame}. if \code{data} is a \code{rpart}, 
data.frame used to build tree in order to plot \code{sparkline}}

\item{tooltipColumns}{\code{numeric}, indice of columns used in tooltip. All by default.
So, we add boxplot / pie focus on sub-population vs all population using \code{sparkline} package. \code{NULL} to disable.}

\item{main}{Title. See \link{visNetwork}}

\item{submain}{Subtitle. See \link{visNetwork}}

\item{footer}{Footer. See \link{visNetwork}}

\item{direction}{\code{character}, The direction of the hierarchical layout.
The available options are: UD, DU, LR, RL. To simplify:
up-down, down-up, left-right, right-left. Default UD. See \link{visHierarchicalLayout}}

\item{fallenLeaves}{\code{boolean} leaf nodes at the bottom of the graph ? Default to FALSE}

\item{rules}{\code{boolean}, add rules in tooltips ? Default to TRUE}

\item{simplifyRules}{\code{boolean}, simplify rules writing}

\item{shapeVar}{\code{character}, shape for variables nodes See \link{visNodes}}

\item{shapeY}{\code{character}, shape for terminal nodes See \link{visNodes}}

\item{colorVar}{\code{character}, colors to use or \code{data.frame} To set color of variables. 2 columns :
\itemize{
  \item{"variable"}{ : names of variables}
  \item{"color"}{ : colors (in hexa). See examples}
}}

\item{colorY}{if classification tree : \code{character} colors to use or \code{data.frame} 2 columns :
\itemize{
  \item{"modality"}{ : levels of Y}
  \item{"color"}{ : colors (in hexa)}
}
if regression tree : \code{character}, 2 colors (min and max, in hexa)}

\item{colorEdges}{\code{character}, color of edges, in hexa. Default to #8181F7}

\item{nodesFontSize}{\code{numeric}, size of labels of nodes. Default to 16}

\item{edgesFontSize}{\code{numeric}, size of labels of edges Default to 14}

\item{edgesFontAlign}{\code{character}, for edges only. Default tp 'horizontal'. Possible options: 'horizontal' (Default),'top','middle','bottom'. See \link{visEdges}}

\item{legend}{\code{boolean}, add legend ? Default TRUE. \link{visLegend}}

\item{legendNodesSize}{\code{numeric}, size of nodes in legend. Default to 22}

\item{legendFontSize}{\code{numeric}, size of labels of nodes in legend. Default to 16}

\item{legendWidth}{\code{numeric}, legend width, between 0 and 1. Default 0.1}

\item{legendNcol}{\code{numeric}, number of columns in legend. Default 1}

\item{legendPosition}{\code{character}, one of "left" (Default) or "right"}

\item{nodesPopSize}{\code{boolean}, nodes sizes depends on population ? Default to FALSE}

\item{minNodeSize}{\code{numeric}, in case of \code{nodesPopSize}, minimum size of a node. Defaut to 15. Else, nodes size is minNodeSize + maxNodeSize / 2}

\item{maxNodeSize}{\code{numeric}, in case of \code{nodesPopSize}, maximum size of a node. Defaut to 30. Else, nodes size is minNodeSize + maxNodeSize / 2}

\item{highlightNearest}{\code{list}, Highlight nearest nodes. See \link{visOptions}}

\item{collapse}{\code{list}, collapse or not using double click on a node ? See \link{visOptions}}

\item{updateShape}{\code{boolean}, in case of collapse, udpate cluster node shape as terminal node ? Default to TRUE}

\item{tooltipDelay}{\code{numeric}, delay for tooltips in millisecond. Default 500}

\item{digits}{\code{numeric}, number of digits. Default to 3}

\item{height}{\code{character}, default to "600px"}

\item{width}{\code{character}, default to "100\%"}

\item{export}{\code{boolean}, add export button. Default to TRUE}

\item{id}{\code{character} id of module, linked to  \link{visTreeModuleServer}}

\item{rpartParams}{\code{boolean}, add tabs for rpart parameters (in case of \code{data.frame} in input)}

\item{visTreeParams}{\code{boolean}, add tabs for visTree parameters. Default to TRUE. Force to TRUE if \code{rpartParams}}

\item{quitButton}{\code{boolean}, add a button to quit module and get back network in R ?}
}
\description{
Needed packages : shiny, rpart, colourpicker, shinyWidgets, sparkline
}
\examples{
\dontrun{

require(rpart)
# simple module editor on rpart
data <- iris
shiny::shinyApp(ui = shiny::fluidPage(
visTreeModuleUI(id = "id1", rpartParams = FALSE, visTreeParams = FALSE)), 
 server = function(input, output, session) {
 shiny::callModule(visTreeModuleServer, "id1", data = shiny::reactive(rpart(data)))
})

# full module editor on rpart + data.frame for sparkline
data <- iris
shiny::shinyApp(ui = shiny::fluidPage(
 visTreeModuleUI(id = "id1", rpartParams = FALSE, visTreeParams = TRUE)), 
 server = function(input, output, session) {
 shiny::callModule(visTreeModuleServer, "id1", data = shiny::reactive(rpart(data)), 
 tooltip_data = data)
})

# module on data.frame
shiny::shinyApp(ui = shiny::fluidPage(visTreeModuleUI(id = "id1",
 rpartParams = TRUE)), 
 server = function(input, output, session) {
 shiny::callModule(visTreeModuleServer, "id1", data = shiny::reactive(data))
})

# multiple modules
shiny::shinyApp(ui = 
navbarPage("Menu",shiny::tabPanel(
  "tt1",shiny::fluidPage(visTreeModuleUI(id = "id1", 
  rpartParams = TRUE,
  visTreeParams = TRUE))
),
shiny::tabPanel(
  "tt2",shiny::fluidPage(visTreeModuleUI(id = "id2", 
  rpartParams = FALSE,
  visTreeParams = FALSE)))
), 
server = function(input, output, session) {
  shiny::callModule(visTreeModuleServer, "id1", data = shiny::reactive(iris))
  shiny::callModule(visTreeModuleServer, "id2", data = shiny::reactive(rpart(iris)))
})
}

}
\references{
See online documentation \url{http://datastorm-open.github.io/visNetwork/}
}
