% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatEstimateName.R
\name{formatEstimateName}
\alias{formatEstimateName}
\title{Formats estimate_name and estimate_value column}
\usage{
formatEstimateName(
  result,
  estimateNameFormat = NULL,
  keepNotFormatted = TRUE,
  useFormatOrder = TRUE
)
}
\arguments{
\item{result}{A summarised_result.}

\item{estimateNameFormat}{Named list of estimate name's to join, sorted by
computation order. Indicate estimate_name's between <...>.}

\item{keepNotFormatted}{Whether to keep rows not formatted.}

\item{useFormatOrder}{Whether to use the order in which estimate names
appear in the estimateNameFormat (TRUE), or use the order in the
input dataframe (FALSE).}
}
\value{
A summarised_result object.
}
\description{
Formats estimate_name and estimate_value columns by changing the name of the
estimate name and/or joining different estimates together in a single row.
}
\examples{
result <- mockSummarisedResult()
result |>
  formatEstimateName(
    estimateNameFormat = c(
      "N (\%)" = "<count> (<percentage>\%)", "N" = "<count>"
    ),
    keepNotFormatted = FALSE
  )

}
