% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_quantile.R
\name{get_quantile}
\alias{get_quantile}
\alias{get_quantile.survfit}
\title{Wrapper around quantile methods}
\usage{
get_quantile(x, ...)

\method{get_quantile}{survfit}(
  x,
  ...,
  probs = c(0.25, 0.5, 0.75),
  conf.int = TRUE,
  tolerance = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{x}{An object of class \code{survfit}}

\item{...}{other arguments passed on to the method}

\item{probs}{probabilities Default = c(0.25,0.50,0.75)}

\item{conf.int}{should lower and upper confidence limits be returned?}

\item{tolerance}{tolerance for checking that the survival curve exactly
    equals one of the quantiles}
}
\value{
A data frame with quantiles of the object
}
\description{
S3 method for extracting quantiles.
No default method is available at the moment.
}
\examples{

## Kaplan-Meier estimates
survfit_object <- visR::estimate_KM(data = adtte, strata = c("TRTP"))

## visR quantiles
visR::get_quantile(survfit_object)

## survival quantiles
quantile(survfit_object)

}
\seealso{
\code{\link[survival]{quantile.survfit}}
}
