#' PLot ranges and events together as one plot
#'
#' @param data the data frame to plot
#' @param title title of the plot, can be NULL
#' @param ranges ranges as generated by plot_ranges
#' @param events events as generated by plot_ranges
#'
#' @return plotly plot
plot_glued <- function(data, title, ranges, events) {
  plotList <- append(ranges, events)

  # sort plotList according to subplots, such that ranges and events stand together
  plotList <- plotList[order(names(plotList))]

  # determine heights of the subplots
  heightsAbsolute <- sapply(
    as.integer(c(names(ranges), names(events))),
    function(sp) {
      max(data$y[data$subplot == sp])
    }
  )
  heightsRelative <- heightsAbsolute / sum(heightsAbsolute)

  subplot(plotList, nrows = length(plotList), shareX = T, margin = 0,
          heights = heightsRelative) %>%
    layout(
      title = title,
      margin = list(l = max(nchar(data$group)) * 8)
    )
}
