% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/undo_pr.R
\name{undo_sd}
\alias{undo_sd}
\title{Undo a mean/difference transformation}
\usage{
undo_sd(.data, .var, key = Sex, times = 2000)
}
\arguments{
\item{.data}{A vital object}

\item{.var}{A bare variable name of the measured variable to use.}

\item{key}{A bare variable name specifying the key variable to use. This key
variable must include the value \code{geometric_mean}.}

\item{times}{When the variable is a distribution, the product must be computed
by simulation. This argument specifies the number of simulations to use.}
}
\value{
A vital object
}
\description{
Make a new vital from means and differences of a measured variable by a
key variable. The most common use case of this function is for computing migration numbers by
sex, from the sex differences and mean of the numbers.
}
\examples{
# Make sums and differences
mig <- net_migration(norway_mortality, norway_births) |>
  dplyr::filter(Sex != "Total")
sd <- mig |>
  make_sd(NetMigration)
# Undo products and ratios
sd |> undo_sd(NetMigration)
}
\references{
Hyndman, R.J., Booth, H., & Yasmeen, F. (2013). Coherent
mortality forecasting: the product-ratio method with functional time series
models. \emph{Demography}, 50(1), 261-283.
}
