% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_hr.R
\name{extract_hr}
\alias{extract_hr}
\title{Extract HR attribute variables}
\usage{
extract_hr(data, max_unique = 50, exclude_constants = TRUE, return = "names")
}
\arguments{
\item{data}{A data frame to be passed through.}

\item{max_unique}{A numeric value representing the maximum
number of unique values to accept for an HR attribute. Defaults to 50.}

\item{exclude_constants}{Logical value to specify whether single-value HR
attributes are to be excluded. Defaults to \code{TRUE}.}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"names"}
\item \code{"vars"}
}

See \code{Value} for more information.}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"names"}: character vector identifying all the names of HR variables
present in the data.
\item \code{"vars"}: data frame containing all the columns of HR variables present
in the data.
}
}
\description{
This function uses a combination of variable class,
number of unique values, and regular expression matching
to extract HR / organisational attributes from a data frame.
}
\examples{
pq_data \%>\% extract_hr(return = "names")

pq_data \%>\% extract_hr(return = "vars")

}
\seealso{
Other Support: 
\code{\link{camel_clean}()},
\code{\link{check_inputs}()},
\code{\link{cut_hour}()},
\code{\link{extract_date_range}()},
\code{\link{heat_colours}()},
\code{\link{is_date_format}()},
\code{\link{maxmin}()},
\code{\link{rgb2hex}()},
\code{\link{totals_bind}()},
\code{\link{totals_col}()},
\code{\link{tstamp}()},
\code{\link{us_to_space}()},
\code{\link{wrap}()}

Other Data Validation: 
\code{\link{hr_trend}()},
\code{\link{hrvar_count_all}()},
\code{\link{hrvar_count}()},
\code{\link{hrvar_trend}()}
}
\concept{Data Validation}
\concept{Support}
