% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/totals_col.R
\name{totals_col}
\alias{totals_col}
\title{Fabricate a 'Total' HR variable}
\usage{
totals_col(data, total_value = "Total")
}
\arguments{
\item{data}{data frame}

\item{total_value}{Character value defining the name and the value of the
\code{"Total"} column. Defaults to \code{"Total"}. An error is returned if an
existing variable has the same name as the supplied value.}
}
\value{
data frame containing an additional 'Total' column on top of the input data
frame.
}
\description{
Create a 'Total' column of character type comprising exactly of
one unique value. This is a convenience function for returning a no-HR
attribute view when \code{NULL} is supplied to the \code{hrvar} argument in
functions.
}
\examples{
# Create a visual without HR attribute breaks
pq_data \%>\%
  totals_col() \%>\%
  create_fizz(hrvar = "Total", metric = "Email_hours")

}
\seealso{
Other Support: 
\code{\link{camel_clean}()},
\code{\link{check_inputs}()},
\code{\link{cut_hour}()},
\code{\link{extract_date_range}()},
\code{\link{extract_hr}()},
\code{\link{heat_colours}()},
\code{\link{is_date_format}()},
\code{\link{maxmin}()},
\code{\link{rgb2hex}()},
\code{\link{totals_bind}()},
\code{\link{tstamp}()},
\code{\link{us_to_space}()},
\code{\link{wrap}()}
}
\concept{Support}
