% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tab_metrics_items_grouped}
\alias{tab_metrics_items_grouped}
\title{Output the means for groups in one or multiple columns}
\usage{
tab_metrics_items_grouped(
  data,
  cols,
  cross,
  negative = FALSE,
  digits = 1,
  values = c("m", "sd"),
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble.}

\item{cols}{The item columns that hold the values to summarize.}

\item{cross}{The column holding groups to compare.}

\item{negative}{If FALSE (default), negative values are recoded as missing values.}

\item{digits}{The number of digits to print.}

\item{values}{The output metrics, mean (m), the standard deviation (sd) or both (the default).}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{tab_metrics}.}
}
\value{
A volker tibble.
}
\description{
Output the means for groups in one or multiple columns
}
\examples{
library(volker)
data <- volker::chatgpt

tab_metrics_items_grouped(data, starts_with("cg_adoption_"), sd_gender)

}
\keyword{internal}
