% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddUserData.twitter.R
\name{vosonSML::AddUserData.twitter}
\alias{vosonSML::AddUserData.twitter}
\alias{AddUserData.twitter}
\title{Enhances twitter actor network graph by adding user attributes to nodes}
\usage{
AddUserData.twitter(collectData, networkData, lookupUsers = TRUE,
  twitterAuth = NULL, writeToFile = FALSE)
}
\arguments{
\item{collectData}{A dataframe containing the collected tweet data from the \code{Collect} function.}

\item{networkData}{A named list containing the relations \code{$relations} and users \code{$users} data returned 
from the \code{Create} actor network function.}

\item{lookupUsers}{Logical. Lookup user profile information using the twitter API for any users data missing from 
the collect data set. For example fetches profile information for users that became nodes during network creation 
because they were mentioned in a tweet but did not author any tweets themselves. Default is \code{TRUE}.}

\item{twitterAuth}{A twitter authentication object from \code{Authenticate}.}

\item{writeToFile}{Logical. If \code{TRUE} a data frame of user information and the resulting network graph will 
be written to file in \code{rds} and \code{graphml} formats respectively. Default is \code{FALSE}.}
}
\value{
A named list containing a dataframe with user information \code{$users} and an igraph object of the twitter 
actor network with supplemental user node attributes \code{$graph}.
}
\description{
Creates a network from the relations and users dataframes generated by Create. Network is supplemented with 
additional downloaded twitter user information applied as node attributes.
}
\note{
Only supports twitter actor network at this time. Bimodal network support could be achieved by the filtering 
of the twitter user ids from nodes of other types in the \code{networkData}. Refer to S3 methods 
\code{\link{Authenticate.twitter}}, \code{\link{Collect.twitter}} and \code{\link{Create.actor.twitter}} to first 
create twitter actor network and data to pass as input into this function.
}
\examples{
\dontrun{
# add additional twitter user profile information to actor network graph as node attributes 
# requires twitterAuth from Authenticate, twitterData from Collect and actorNetwork from 
# Create actor network
actorNetWithUserAttr <- AddUserData.twitter(twitterData, actorNetwork,
                                            lookupUsers = TRUE, 
                                            twitterAuth = twitterAuth, writeToFile = TRUE)
# igraph object
# actorNetWithUserAttr$graph
}

}
