% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Collect.reddit.R
\name{Collect.reddit}
\alias{Collect.reddit}
\title{Collect comments data from reddit threads}
\usage{
\method{Collect}{reddit}(credential, threadUrls, waitTime = 5,
  writeToFile = FALSE, ...)
}
\arguments{
\item{credential}{A \code{credential} object generated from \code{Authenticate} with class name \code{"reddit"}.}

\item{threadUrls}{Character vector. Reddit thread urls to collect data from.}

\item{waitTime}{Numeric integer. Time in seconds to wait in-between url collection requests.}

\item{writeToFile}{Logical. Write collected data to file. Default is \code{FALSE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
A \code{data.frame} object with class names \code{"datasource"} and \code{"reddit"}.
}
\description{
Collects comments made by users on one or more specified subreddit conversation threads and structures 
the data into a dataframe with the class names \code{"datasource"} and \code{"reddit"}.
}
\note{
The reddit web endpoint used for collection has maximum limit of 500 comments per thread url.
}
\examples{
\dontrun{
# subreddit url to collect threads from
threadUrls <- c("https://www.reddit.com/r/xxxxxx/comments/xxxxxx/x_xxxx_xxxxxxxxx/")

redditData <- redditAuth \%>\%
  Collect(threadUrls = threadUrls, waitTime = 3, writeToFile = TRUE)
}

}
