% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Collect.reddit.R, R/wrappers.R
\name{Collect.reddit}
\alias{Collect.reddit}
\alias{collect_reddit_threads}
\title{Collect comments data from reddit threads}
\usage{
\method{Collect}{reddit}(
  credential,
  threadUrls,
  waitTime = c(3, 5),
  ua = getOption("HTTPUserAgent"),
  writeToFile = FALSE,
  verbose = FALSE,
  ...
)

collect_reddit_threads(
  threadUrls,
  waitTime = c(3, 5),
  ua = getOption("HTTPUserAgent"),
  writeToFile = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{credential}{A \code{credential} object generated from \code{Authenticate} with class name \code{"reddit"}.}

\item{threadUrls}{Character vector. Reddit thread urls to collect data from.}

\item{waitTime}{Numeric vector. Time range in seconds to select random wait from in-between url collection requests.
Minimum is 3 seconds. Default is \code{c(3, 5)} for a wait time chosen from between 3 and 5 seconds.}

\item{ua}{Character string. Override User-Agent string to use in Reddit thread requests. Default is
\code{option("HTTPUserAgent")} value as set by vosonSML.}

\item{writeToFile}{Logical. Write collected data to file. Default is \code{FALSE}.}

\item{verbose}{Logical. Output additional information about the data collection. Default is \code{TRUE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
A \code{tibble} object with class names \code{"datasource"} and \code{"reddit"}.
}
\description{
Collects comments made by users on one or more specified subreddit conversation threads and structures
the data into a dataframe with the class names \code{"datasource"} and \code{"reddit"}.
}
\note{
The reddit web endpoint used for collection has maximum limit of 500 comments per thread url.
}
\examples{
\dontrun{
# subreddit url to collect threads from
threadUrls <- c("https://www.reddit.com/r/xxxxxx/comments/xxxxxx/x_xxxx_xxxxxxxxx/")

redditData <- redditAuth |>
  Collect(threadUrls = threadUrls, writeToFile = TRUE)
}

}
