% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vroom_write.R
\name{vroom_format}
\alias{vroom_format}
\title{Convert a data frame to a delimited string}
\usage{
vroom_format(
  x,
  delim = "\\t",
  na = "NA",
  col_names = TRUE,
  escape = c("double", "backslash", "none"),
  quote = c("needed", "all", "none"),
  bom = FALSE
)
}
\arguments{
\item{x}{A data frame to write to disk}

\item{delim}{Delimiter used to separate values. Defaults to \verb{\\t} to write
tab separated value (TSV) files.}

\item{na}{String used for missing values. Defaults to 'NA'.}

\item{col_names}{Write columns names at the top of the file? Must be either
\code{TRUE} or \code{FALSE}.}

\item{escape}{The type of escape to use when quotes are in the data.
\itemize{
\item \code{double} - quotes are escaped by doubling them.
\item \code{backslash} - quotes are escaped by a preceding backslash.
\item \code{none} - quotes are not escaped.
}}

\item{quote}{How to handle fields which contain characters that need to be quoted.
\itemize{
\item \code{needed} - Only quote fields which need them.
\item \code{all} - Quote all fields.
\item \code{none} - Never quote fields.
}}

\item{bom}{If \code{TRUE} add a UTF-8 BOM at the beginning of the file. This is
recommended when saving data for consumption by excel, as it will force
excel to read the data with the correct encoding (UTF-8)}
}
\description{
This is equivalent to \code{\link[=vroom_write]{vroom_write()}}, but instead of writing to
disk, it returns a string. It is primarily useful for examples and for
testing.
}
