% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_no_duplicate_rows.R
\name{check_no_duplicate_rows}
\alias{check_no_duplicate_rows}
\title{Check for No Duplicate Rows}
\usage{
check_no_duplicate_rows(dataframe, collection, unique_columns = NULL)
}
\arguments{
\item{dataframe}{A dataframe.}

\item{collection}{A list to store the message if there are duplicate rows.}

\item{unique_columns}{Default is NULL. If provided, these are the columns to check for uniqueness.}
}
\value{
The updated collection.
}
\description{
This function checks if there are any duplicate rows in the provided dataframe.
If there are duplicate rows, a message is added to the provided collection.
}
\examples{
# Create a dataframe with some duplicate rows
dataframe <- data.frame(a = c(1, 1, 2), b = c(2, 2, 3))
collection <- checkmate::makeAssertCollection()
check_no_duplicate_rows(dataframe, collection, c("a", "b"))
}
