% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_server_workbooks.R
\name{get_server_workbooks}
\alias{get_server_workbooks}
\title{Get workbooks from Tableau server.}
\usage{
get_server_workbooks(
  tableau,
  api_version = "3.4",
  page_size = 100,
  include_metadata = FALSE
)
}
\arguments{
\item{tableau}{A list containing the Tableau authentication variables: `base_url`, `token`, `user_id`, and `site_id`.}

\item{api_version}{The API version to use (default: 3.4).}

\item{page_size}{The number of workbooks to retrieve per page (default: 100).}

\item{include_metadata}{Logical indicating whether to include metadata columns in the result (default: FALSE).}
}
\value{
A data frame containing the workbooks information.
}
\description{
Retrieves a list of workbooks from the Tableau server using the provided authentication credentials.
}
\seealso{
Other Tableau REST API: 
\code{\link{authenticate_server}()},
\code{\link{download_filtered_tableau_image}()},
\code{\link{download_tableau_crosstab_excel}()},
\code{\link{download_tableau_data}()},
\code{\link{download_workbooks_server_pdf}()},
\code{\link{download_workbooks_server_powerpoint}()},
\code{\link{download_workbooks_server}()},
\code{\link{get_server_connected_apps}()},
\code{\link{get_server_datasources}()},
\code{\link{get_server_groups}()},
\code{\link{get_server_info}()},
\code{\link{get_server_jobs}()},
\code{\link{get_server_projects}()},
\code{\link{get_server_refresh_tasks}()},
\code{\link{get_server_schedules}()},
\code{\link{get_server_user_favorites}()},
\code{\link{get_server_users}()},
\code{\link{get_server_views}()}
}
\concept{Tableau REST API}
