\name{grid.vwcurve}
\alias{grid.vwcurve}
\alias{vwcurveGrob}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Draw a variable-width smooth curve.
}
\description{
  Draw a variable-width line where the main line is a series
  of straight line segments that are assumed to be
  a flattened approximation to a smooth curve and the width is specified at
  each vertex along the flattened curve.
}
\usage{
vwcurveGrob(x, y, w, default.units="npc", open=TRUE, angle="perp",
           lineend="butt", mitrelimit=4,
           render=if (open) vwPolygon else vwPath(),
           gp=gpar(fill="black"), name=NULL, debug=FALSE)
grid.vwcurve(...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{A numeric vector or unit describing x-locations.}
  \item{y}{A numeric vector or unit describing y-locations.}
  \item{w}{A numeric vector or unit describing widths at each location,
    or a width specification generated by \code{\link{widthSpec}}.}
  \item{default.units}{The units used if \code{x} or \code{y} are
    numeric vectors.}
  \item{open}{A boolean indicating whether to connect the last location
    back to the first location to produce a closed line.}
  \item{angle}{Either \code{"perp"} or a numeric value describing a
    fixed orientation for the line width.}
  \item{lineend}{The line ending style; one of \code{"round"},
    \code{"mitre"}, \code{"butt"}, or \code{"square"}.}
  \item{mitrelimit}{A numeric that controls when a mitre join is
    converted to a bevel join or a mitre ending
    is converted to a square ending.}
  \item{render}{A function that is used to render the outline of the path
    that is generated for the variable-width line.}
  \item{gp}{A set of graphical parameters; see \code{\link{gpar}}.}
  \item{name}{A name for the grob generated for the variable-width
    line.}
  \item{debug}{A logical indicating whether to produce graphical
    debugging output.}
  \item{\dots}{
    Arguments passed to \code{vwcurveGrob}.
  }
}
\details{
  The widths are calculated perpendicular to the average angle at each
  vertex (or just perpendicular to the line segment for the first and
  last vertex), \emph{unless} a numeric \code{angle} is specified, in
  which case the widths are calculated at that angle at every vertex.
}
\value{
  \code{grid.vwcurve} is used for its side-effect of drawing a
  variable-width
  line;  \code{vwcurveGrob} returns a \code{"vwcurveGrob"} object.
}
\author{
  Paul Murrell
}
\seealso{
  \code{\link{grid.vwline}},
  \code{\link{grid.vwXspline}},
  \code{\link{grid.brushXspline}},
  \code{\link{grid.offsetXspline}}
}
\examples{
grid.newpage()
x <- seq(.2, .8, length.out=100)
y <- .05*sin(seq(0, 2*pi, length.out=100))
w <- unit(seq(2, 10, length.out=100), "mm")
grid.vwcurve(x, y + .8, w)
grid.vwcurve(x, y + .6, w,
             angle=45)
grid.vwcurve(x, y + .4, w,
             lineend="round")
grid.vwcurve(x, y + .2, w,
             gp=gpar(col="black"), debug=TRUE)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ aplot }% use one of  RShowDoc("KEYWORDS")
