% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_series_export.R
\name{get_series}
\alias{get_series}
\title{Requests data from multiple data sources.}
\usage{
get_series(
  index = NULL,
  start_date = default_start_date(),
  end_date = default_end_date(),
  freq = NULL,
  cache = FALSE,
  na.remove = TRUE,
  verbose = NULL,
  ...,
  source = c("multi", "evds", "fred"),
  base = c("multi", "series", "table"),
  debug = FALSE
)
}
\arguments{
\item{index}{A character vector or string representing the index to be retrieved.}

\item{start_date}{Limits the start date of the data.}

\item{end_date}{Limits the end date of the data.}

\item{freq}{Frequency of the data (rarely needed).}

\item{cache}{If FALSE, a new request will be made; if TRUE, cached data will be used.}

\item{na.remove}{If TRUE, NA values are removed only if all columns are NA.}

\item{verbose}{If TRUE, prints information during the process; if FALSE, silently does its job.
default is NULL which implies applying default verbose option. If this function is called with
a TRUE or FALSE value it changes global verbose option for \code{vyos} package.
If verbose option is FALSE it gives a warning only if something goes wrong.}

\item{...}{Additional parameters for future versions.}

\item{source}{Source such as "evds" or "fred" for internal use at this version.}

\item{base}{Table or series on the source for internal use at this version.}

\item{debug}{Debug option for development.}
}
\value{
An S3 object, vyos_GETPREP, which has generic functions such as print and excel.
The \code{print} generic provides hints to the user on how to use requested data,
such as creating output with the \code{excel} function or examining requested data in the global environment.
}
\description{
The \code{get_series()} function retrieves data from various sources, including the EDDS API and FRED API at this version.
When multiple indexes are provided as a character vector or string template, the function individually
requests each item from the corresponding sources, discerning the source from the item's format.
The function combines data frames when there are common frequencies and returns both a combined data frame and
individual data frames for each requested item.
}
\examples{
\dontrun{
o <- get_series(template_test())
excel(o)
object <- get_series("UNRATE", start_date = "2000/01/01", na.remove = TRUE)
excel(object)
}
}
