% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isochrone_pois.R
\name{pois_walktimes}
\alias{pois_walktimes}
\title{Extract walking times to points-of-interest}
\usage{
pois_walktimes(isochrone_pois)
}
\arguments{
\item{isochrone_pois}{a response object from a \link[walkalytics]{isochrone_pois} call to the \code{walkalytics} isochrone API.}
}
\value{
A \code{data.frame} (\code{tibble::tibble}) that contains:
\itemize{
\item \code{id} id of the point-of-interest.
\item \code{walktime} estimated walking time from the starting point to the point-of-interest in seconds.
\item \code{x} x-coordinate of the point-of-interest.
\item \code{y} y-coordinate of the point-of-interest.
}
}
\description{
\code{pois_walktimes} processses a response object from a \link[walkalytics]{isochrone_pois} call to the \code{walkalytics} pubtrans API.
   Returns walking times from the source location to the given points-of-interest, ordered by walking time.
}
\details{
To get an API key, you need to register at \url{https://dev.walkalytics.com/signin}.
    With the free starter account, you can make up to 100 calls a week to the API.
}
\examples{
\donttest{
# Generate set of POIs
x <- c(895777, 896044, 895639)
y <- c(6004833, 6004886, 6005147)
id <- c("pupil1", "pupil2", "pupil3")
pupils <- data.frame(x = x, y = y, id = id)

# Issue query
isochrone_pois(x = 895815, y = 6004839, pois = pupils, key = "abcd1234") \%>\% pois_walktimes()
}
}
\references{
\href{https://dev.walkalytics.com/docs/services/}{Walkalytics API documentations}
}
