
# This file is automatically generated, you probably don't want to edit this

ranovaOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "ranovaOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            dep = NULL,
            factors = NULL,
            method = "trim",
            ph = FALSE,
            tr = 0.2,
            est = "mom",
            nboot = 599,
            dist = "proj", ...) {

            super$initialize(
                package='walrus',
                name='ranova',
                requiresData=TRUE,
                ...)
        
            private$..dep <- jmvcore::OptionVariable$new(
                "dep",
                dep,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"))
            private$..factors <- jmvcore::OptionVariables$new(
                "factors",
                factors,
                suggested=list(
                    "nominal",
                    "ordinal"),
                default=NULL)
            private$..method <- jmvcore::OptionList$new(
                "method",
                method,
                options=list(
                    "median",
                    "trim",
                    "boot"),
                default="trim")
            private$..ph <- jmvcore::OptionBool$new(
                "ph",
                ph,
                default=FALSE)
            private$..tr <- jmvcore::OptionNumber$new(
                "tr",
                tr,
                min=0,
                max=0.5,
                default=0.2)
            private$..est <- jmvcore::OptionList$new(
                "est",
                est,
                options=list(
                    "onestep",
                    "mom",
                    "median"),
                default="mom")
            private$..nboot <- jmvcore::OptionInteger$new(
                "nboot",
                nboot,
                min=0,
                default=599)
            private$..dist <- jmvcore::OptionList$new(
                "dist",
                dist,
                options=list(
                    "maha",
                    "proj"),
                default="proj")
        
            self$.addOption(private$..dep)
            self$.addOption(private$..factors)
            self$.addOption(private$..method)
            self$.addOption(private$..ph)
            self$.addOption(private$..tr)
            self$.addOption(private$..est)
            self$.addOption(private$..nboot)
            self$.addOption(private$..dist)
        }),
    active = list(
        dep = function() private$..dep$value,
        factors = function() private$..factors$value,
        method = function() private$..method$value,
        ph = function() private$..ph$value,
        tr = function() private$..tr$value,
        est = function() private$..est$value,
        nboot = function() private$..nboot$value,
        dist = function() private$..dist$value),
    private = list(
        ..dep = NA,
        ..factors = NA,
        ..method = NA,
        ..ph = NA,
        ..tr = NA,
        ..est = NA,
        ..nboot = NA,
        ..dist = NA)
)

ranovaResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        main = function() private$..main,
        phs = function() private$..phs),
    private = list(
        ..main = NA,
        ..phs = NA),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Robust ANOVA")
            private$..main <- jmvcore::Table$new(
                options=options,
                name="main",
                title="Robust ANOVA",
                clearWith=list(
                    "dep",
                    "factors",
                    "method",
                    "nboot",
                    "tr",
                    "est",
                    "dist"),
                columns=list(
                    list(
                        `name`="name", 
                        `title`="", 
                        `type`="text"),
                    list(
                        `name`="s", 
                        `title`="F", 
                        `type`="number"),
                    list(
                        `name`="p", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue")))
            private$..phs <- jmvcore::Array$new(
                options=options,
                name="phs",
                title="Post Hoc Tests",
                items="(factors)",
                visible="(ph)",
                template=jmvcore::Table$new(
                    options=options,
                    name="ph",
                    title="Post Hoc Tests - $key",
                    clearWith=list(
                        "dep",
                        "factors",
                        "method",
                        "nboot",
                        "tr",
                        "est",
                        "dist"),
                    columns=list(
                        list(
                            `name`="v1", 
                            `title`="", 
                            `type`="text"),
                        list(
                            `name`="v2", 
                            `title`="", 
                            `type`="text"),
                        list(
                            `name`="psi", 
                            `title`="psi-hat", 
                            `type`="number"),
                        list(
                            `name`="p", 
                            `title`="p", 
                            `type`="number", 
                            `format`="zto,pvalue"),
                        list(
                            `name`="cil", 
                            `title`="Lower", 
                            `superTitle`="95% Confidence interval", 
                            `type`="number"),
                        list(
                            `name`="ciu", 
                            `title`="Upper", 
                            `superTitle`="95% Confidence interval", 
                            `type`="number"))))
            self$add(private$..main)
            self$add(private$..phs)}))

ranovaBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "ranovaBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'walrus',
                name = 'ranova',
                version = c(1,0,0),
                options = options,
                results = ranovaResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE)
        }))

#' Robust ANOVA
#'
#' Robust Analysis of Variance
#'
#' @examples
#' data('goggles', package='WRS2')
#' 
#' ranova(goggles,
#'        dep = 'attractiveness',
#'        factors = c('gender', 'alcohol'),
#'        ph = TRUE)
#' 
#' #
#' #  ROBUST ANOVA
#' #
#' #  Robust ANOVA
#' #  ------------------------------------
#' #                      Q        p
#' #  ------------------------------------
#' #    gender             1.67    0.209
#' #    alcohol           48.28    0.001
#' #    gender:alcohol    26.26    0.001
#' #  ------------------------------------
#' #   Note. Method of trimmed means,
#' #   trim level 0.2
#' #
#' #
#' #  POST HOC TESTS
#' #
#' #  Post Hoc Tests - gender
#' #  --------------------------------------------------------
#' #                       psi-hat   p        Lower    Upper
#' #  --------------------------------------------------------
#' #    Female    Male     10.0      0.209    -6.00    26.0
#' #  --------------------------------------------------------
#' #
#' #
#' #  Post Hoc Tests - alcohol
#' #  -------------------------------------------------------------
#' #                           psi-hat   p         Lower    Upper
#' #  -------------------------------------------------------------
#' #    None       2 Pints     -3.33      0.611    -20.5     13.8
#' #    None       4 Pints     35.83     < .001     19.3     52.3
#' #    2 Pints    4 Pints     39.17     < .001     22.5     55.9
#' #  -------------------------------------------------------------
#' #
#' 
#' @param data the data as a data frame
#' @param dep a string naming the dependent variable from \code{data}; the 
#'   variable must be numeric 
#' @param factors a vector of strings naming the fixed factors from 
#'   \code{data}
#' @param method \code{'median'}, \code{'trim'} (default) or \code{'boot'}; 
#'   the method to use, median, trimmed means, or bootstrapped 
#' @param ph \code{TRUE} or \code{FALSE} (default), provide post hoc tests 
#' @param tr a number between 0 and 0.5, (default: 0.2), the proportion of 
#'   measurements to trim from each end, when using the trim and bootstrap 
#'   methods 
#' @param est \code{'onestep'}, \code{'mom'} (default) or \code{'median'}, the 
#'   M-estimator to use; One-step, Modified one-step or Median respectively 
#' @param nboot a number (default: 599) specifying the number of bootstrap 
#'   samples to use when using the bootstrap method 
#' @param dist \code{'maha'} or \code{'proj'} (default), whether to use 
#'   Mahalanobis or Projection distances respectively 
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$main} \tab \tab \tab \tab \tab the table of ANOVA results \cr
#'   \code{results$phs} \tab \tab \tab \tab \tab the table of posthoc tests \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$main$asDF}
#'
#' \code{as.data.frame(results$main)}
#'
#' @export
ranova <- function(
    data,
    dep,
    factors = NULL,
    method = "trim",
    ph = FALSE,
    tr = 0.2,
    est = "mom",
    nboot = 599,
    dist = "proj") {

    if ( ! requireNamespace('jmvcore'))
        stop('ranova requires jmvcore to be installed (restart may be required)')

    options <- ranovaOptions$new(
        dep = dep,
        factors = factors,
        method = method,
        ph = ph,
        tr = tr,
        est = est,
        nboot = nboot,
        dist = dist)

    results <- ranovaResults$new(
        options = options)

    analysis <- ranovaClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
