% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water_METRIC.R
\name{METRIC.EB}
\alias{METRIC.EB}
\title{Estimates Energy Balance using METRIC2010 Model}
\usage{
METRIC.EB(image.DN, WeatherStation, MTL, sat = "auto", thermalband,
  plain = TRUE, DEM, aoi, alb.coeff = "Tasumi", LAI.method = "metric2010",
  Zom.method = "short.crops", anchors.method = "CITRA-MCB",
  ETp.coef = 1.05, Z.om.ws = 0.0018, ESPA = FALSE, verbose = FALSE)
}
\arguments{
\item{image.DN}{raw imagen in digital counts to evaluate}

\item{WeatherStation}{Weather Station data, can be a waterWeatherStation 
object}

\item{MTL}{Landsat metadata file}

\item{sat}{Landsat satellite version. "L7" or "L8"}

\item{thermalband}{Landsat low gain thermalband}

\item{plain}{Logical. If TRUE surface is assumed plain}

\item{DEM}{Digital Elevation Model of the study area. Not needed
if plain = TRUE}

\item{aoi}{SpatialPolygon object with limits of Area of interest}

\item{alb.coeff}{coefficient to transform narrow to broad band albedo.
See Details.}

\item{LAI.method}{Method used to estimate LAI from spectral data. 
See Details.}

\item{Zom.method}{method selected to calculate momentum roughness 
length. Use "short.crops" for short crops methods from Allen et al (2007); 
"custom" for custom method also in Allen et al (2007); Or "Perrier" to use 
Perrier equation as in Santos et al (2012) and Pocas et al (2014).}

\item{anchors.method}{method to select anchor pixels. Currently only 
"CITRA-MCB" automatic method available.}

\item{ETp.coef}{ETp coefficient usually 1.05 or 1.2 for alfalfa}

\item{Z.om.ws}{momentum roughness lenght for WeatherStation. Usually
0.0018 or 0.03 for long grass}

\item{ESPA}{Logical. If TRUE will look for espa.usgs.gov related 
products on working folder}

\item{verbose}{Logical. If TRUE will print aditional data to console}
}
\description{
Estimates Energy Balance using METRIC2010 Model
}
\details{
There are differents models to convert narrowband data to broadband albedo. 
You can choose alb.coeff ="Tasumi" to use Tasumi et al (2008) coefficients, 
calculated for Landsat 7; alb.coeff ="Liang" to use Liang Landsat 7 
coefficients or "Olmedo" to use Olmedo coefficients for Landsat 8.
}
\author{
Guillermo F Olmedo, \email{guillermo.olmedo@gmail.com}
}
\references{
R. G. Allen, M. Tasumi, and R. Trezza, "Satellite-based energy balance for mapping evapotranspiration with internalized calibration (METRIC) - Model" Journal of Irrigation and Drainage Engineering, vol. 133, p. 380, 2007
}

