% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water_sensibleHeatFlux.R
\name{calcH}
\alias{calcH}
\title{Iterative function to estimate H and R.ah}
\usage{
calcH(anchors, method = "mean", Ts, Z.om, WeatherStation, ETp.coef = 1.05,
  Z.om.ws = 0.03, mountainous = FALSE, DEM, Rn, G, verbose = FALSE,
  maxit = 20)
}
\arguments{
\item{anchors}{anchors points. Can be the result from calcAnchors() or
a spatialPointDataframe o Dataframe with X, Y, and type. type should be 
"cold" or "hot"}

\item{method}{Method when using more than 1 pair of anchors pixels. 
method = "mean" will use the mean value for the cold pixels vs the mean value
for the hot pixels.}

\item{Ts}{Land surface temperature in K. See surfaceTemperature()}

\item{Z.om}{momentum roughness lenght. See momentumRoughnessLength()}

\item{WeatherStation}{WeatherStation data at the satellite overpass. 
Can be a waterWeatherStation object calculated using read.WSdata and MTL file}

\item{ETp.coef}{ETp coefficient usually 1.05 or 1.2 for alfalfa}

\item{Z.om.ws}{momentum roughness lenght for WeatherStation. Usually
a value of 0.03 might be reasonable for a typical agricultural weather station 
sited over vegetation that is about 0.3 m tall.  For clipped grass, use 0.015 m}

\item{mountainous}{Logical. If TRUE heat transfer equation will be 
adjusted for mountainous terrain}

\item{DEM}{Digital Elevation Model in meters.}

\item{Rn}{Net radiation. See netRadiation()}

\item{G}{Soil Heat Flux. See soilHeatFlux()}

\item{verbose}{Logical. If TRUE will print information about every 
iteration to console}

\item{maxit}{Maximun number of iteration. Default 20.}
}
\description{
generates an iterative solution to estimate r.ah and H because both are unknown at each pixel.
}
\details{
Sensible heat flux is the rate of heat loss to the air by convection 
and conduction, due to a temperature difference.This parameter is computed using the following one-dimensional,
aerodynamic,temperature gradient based equation for heat transport, this method is difficult to solve because 
there are two unknowns, rah and dT. To facilitate this computation, METRIC utilize the two "anchor" 
pixels  and solve for dT that satisfies eq. given the aerodynamic roughness and wind speed at a given height.
Aerodynamic resistance, and heat transfer is impacted by buoyancy of heated, light air at the surface, 
especially when H is large. Therefore, correction to rah is needed to account for buoyancy effects. However, 
H is needed to make this correction. An iterative solution for both H and rah is used.
}
\author{
Guillermo Federico Olmedo

de la Fuente-Saiz, Daniel

Fernando Fuentes Peñailillo
}
\references{
R. G. Allen, M. Tasumi, and R. Trezza, "Satellite-based energy balance for mapping evapotranspiration with internalized calibration (METRIC) - Model" Journal of Irrigation and Drainage Engineering, vol. 133, p. 380, 2007 \cr

Allen, R., Irmak, A., Trezza, R., Hendrickx, J.M.H., Bastiaanssen, W., Kjaersgaard, J., 2011. Satellite-based ET estimation in agriculture using SEBAL and METRIC. Hydrol. Process. 25, 4011-4027. doi:10.1002/hyp.8408 \cr
}

