% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_lm_functions.R
\name{extract_lm}
\alias{extract_lm}
\title{Run linear model (lm)}
\usage{
extract_lm(parameter, algorithm, df)
}
\arguments{
\item{parameter}{A string specifying water quality parameter}

\item{algorithm}{A string specifying water quality algorithm}

\item{df}{data frame containing the values for parameter and algorithm arguments}
}
\value{
A data frame of the model results
}
\description{
The function runs a linear model on a single water quality parameter and a water quality algorithm
and returns a data frame containing the following:
r^2, p-value, slope, and intercept of the model
}
\references{
Johansen, Richard; et al. (2018). Evaluating the portability of satellite derived chlorophyll-a algorithms for temperate inland lakes using airborne hyperspectral imagery and dense surface observations. Harmful Algae. 76. 10.1016/j.hal.2018.05.001.

R Core Team (2018). R: A language and environment for statistical computing. R Foundation for Statistical Computing, Vienna, Austria. URL https://www.R-project.org/.
}
\seealso{
Other extract_lm: 
\code{\link{extract_lm_cv_all}()},
\code{\link{extract_lm_cv_multi}()},
\code{\link{extract_lm_cv}()}
}
\concept{extract_lm}
