% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/three_D.R
\name{mra.3d}
\alias{mra.3d}
\title{Three Dimensional Multiresolution Analysis}
\usage{
mra.3d(x, wf = "la8", J = 4, method = "modwt", boundary = "periodic")
}
\arguments{
\item{x}{A three-dimensional array containing the data be to decomposed.
This must be have dyadic length in all three dimensions (but not necessarily
the same) for \code{method="dwt"}.}

\item{wf}{Name of the wavelet filter to use in the decomposition.  By
default this is set to \code{"la8"}, the Daubechies orthonormal compactly
supported wavelet of length \eqn{L=8} least asymmetric family.}

\item{J}{Specifies the depth of the decomposition.  This must be a number
less than or equal to \eqn{\log(\mbox{length}(x),2)}{log(length(x),2)}.}

\item{method}{Either \code{"dwt"} or \code{"modwt"}.}

\item{boundary}{Character string specifying the boundary condition.  If
\code{boundary=="periodic"} the default and only method implemented, then
the matrix you decompose is assumed to be periodic on its defined interval.}
}
\value{
List structure containing the filter triplets associated with the
multiresolution analysis.
}
\description{
This function performs a level \eqn{J} additive decomposition of the input
array using the pyramid algorithm (Mallat 1989).
}
\details{
This code implements a three-dimensional multiresolution analysis by
performing the one-dimensional pyramid algorithm (Mallat 1989) on each
dimension of the input array.  Either the DWT or MODWT may be used to
compute the multiresolution analysis, which is an additive decomposition of
the original array.
}
\references{
Mallat, S. G. (1989) A theory for multiresolution signal
decomposition: the wavelet representation, \emph{IEEE Transactions on
Pattern Analysis and Machine Intelligence}, \bold{11}, No. 7, 674-693.

Mallat, S. G. (1998) \emph{A Wavelet Tour of Signal Processing}, Academic
Press.
}
\seealso{
\code{\link{dwt.3d}}, \code{\link{modwt.3d}}
}
\author{
B. Whitcher
}
\keyword{ts}
