% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdm.R
\name{wdm}
\alias{wdm}
\title{Weighted Dependence Measures}
\usage{
wdm(x, y = NULL, method = "pearson", weights = NULL,
  remove_missing = TRUE)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame.}

\item{y}{\code{NULL} (default) or a vector, matrix or data frame with compatible
dimensions to x. The default is equivalent to `y = x`` (but more
efficient).}

\item{method}{the dependence measure; see \emph{Details} for possible values.}

\item{weights}{an optional vector of weights for the observations.}

\item{remove_missing}{if \code{TRUE}, all incomplete observations containing re
removed; otherwise throws an error if there are any.}
}
\description{
Computes a (possibly weighted) dependence measure between \code{x} and \code{y} if
these are vectors. If \code{x} and \code{y} are matrices then the measure between the
columns of \code{x} and the columns of \code{y} are computed.
}
\details{
Available methods: - \code{"pearson"}: Pearson correlation -
\code{"spearman"}: Spearman's \eqn{\rho} - \code{"kendall"}: Kendall's \eqn{\tau} -
\code{"blomqvist"}: Blomqvist's \eqn{\beta} - \code{"hoeffding"}: Hoeffding's \eqn{D}
Partial matching of method names is enabled.

Spearman's \eqn{\rho} and Kendall's \eqn{\tau} are corrected for ties if
there are any.
}
\examples{
##  dependence between two vectors
x <- rnorm(100)
y <- rpois(100, 1)  # all but Hoeffding's D can handle ties
w <- runif(100)
wdm(x, y, method = "kendall")               # unweighted
wdm(x, y, method = "kendall", weights = w)  # weighted

##  dependence in a matrix
x <- matrix(rnorm(100 * 3), 100, 3)
wdm(x, method = "spearman")               # unweighted
wdm(x, method = "spearman", weights = w)  # weighted

##  dependence between columns of two matrices
y <- matrix(rnorm(100 * 2), 100, 2)
wdm(x, y, method = "hoeffding")               # unweighted
wdm(x, y, method = "hoeffding", weights = w)  # weighted

}
