% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdpa_fetch.R
\name{wdpa_fetch}
\alias{wdpa_fetch}
\title{Fetch data from the World Database on Protected Areas}
\usage{
wdpa_fetch(
  x,
  wait = FALSE,
  download_dir = rappdirs::user_data_dir("wdpar"),
  force_download = FALSE,
  verbose = interactive()
)
}
\arguments{
\item{x}{\code{character} country for which to download data. This argument
can be the name of the country (e.g. \code{"Liechtenstein"}) or the
ISO-3 code for the country (e.g. \code{"LIE"}). This argument can also
be set to \code{"global"} to download all of the protected areas available
in the database (approximately 1.1 GB).}

\item{wait}{\code{logical} if data is not immediately available for download
should the session be paused until it is ready for download? If argument
to \code{wait} is \code{FALSE} and the data is not ready then \code{NA}
will be returned. Defaults to \code{FALSE}.}

\item{download_dir}{\code{character} folder path to download the data.
Defaults to a persistent data directory
(\code{rappdirs::user_data_dir("wdpar")}).}

\item{force_download}{\code{logical} if the data has previously been
downloaded and is available at argument to \code{download_dir}, should a
fresh copy be downloaded? Defaults to \code{FALSE}.}

\item{verbose}{\code{logical} should a progress on downloading data be
reported? Defaults to \code{TRUE} in an interactive session, otherwise
\code{FALSE}.}
}
\value{
\code{\link[sf:sf]{sf::sf()}} object.
}
\description{
Download data from the World Database on Protected Areas (WDPA)
(available at \url{http://protectedplanet.net}) and import it.
}
\details{
This function will download the specified protected area
data and return it. \strong{It is strongly recommended that the data be
cleaned prior to analysis}. Check out the
\code{\link[=wdpa_clean]{wdpa_clean()}} function to clean the data according to standard
practices. For information on this database,
prefer refer to the official manual
(\url{https://www.protectedplanet.net/c/wdpa-manual}).
}
\examples{
\dontrun{
# fetch data for Liechtenstein
lie_raw_data <- wdpa_fetch("Liechtenstein", wait = TRUE)

# fetch data for Liechtenstein using the ISO3 code
lie_raw_data <- wdpa_fetch("LIE")

# plot data
plot(lie_raw_data)
}
}
\seealso{
\code{\link[=wdpa_clean]{wdpa_clean()}}, \code{\link[=wdpa_read]{wdpa_read()}},
\code{\link[=wdpa_url]{wdpa_url()}}, \code{\link[countrycode:countrycode]{countrycode::countrycode()}},
\url{http://protectedplanet.net},
\url{https://www.protectedplanet.net/c/wdpa-manual}.
}
