% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stations.R
\name{stations_dl}
\alias{stations_dl}
\title{Get available stations}
\usage{
stations_dl(skip = NULL, verbose = FALSE, quiet = FALSE)
}
\arguments{
\item{skip}{Numeric. Number of lines to skip at the beginning of the csv. If
NULL, automatically derived.}

\item{verbose}{Logical. Include progress messages}

\item{quiet}{Logical. Suppress all messages (including messages regarding
missing data, etc.)}
}
\description{
This function can be used to download a Station Inventory CSV file from
Environment and Climate Change Canada. This is only necessary if the station
you're interested was only recently added. The 'stations' data set included
in this package contains station data downloaded when the package was last
compiled. This function may take a few minutes to run.
}
\details{
The stations list is downloaded from the url stored in the option
\code{weathercan.urls.stations}. To change this location use
\code{options(weathercan.urls.stations = "your_new_url")}.

The list of which stations have climate normals is downloaded from the url
stored in the option \code{weathercan.urls.stations.normals}. To change this
location use \code{options(weathercan.urls.normals = "your_new_url")}.

Currently there are two sets of climate normals available: 1981-2010 and
1971-2000. Whether a station has climate normals for a given year range is
specified in \code{normals_1981_2010} and \code{normals_1971_2000}, respectively.

The column \code{normals} represents the most current year range of climate
normals (i.e. currently 1981-2010)
}
\examples{
\dontshow{if (check_eccc()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Update stations data frame
stations_dl()

# Updated stations data frame is now automatically used
stations_search("Winnipeg")
\dontshow{\}) # examplesIf}
}
