% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop.R
\name{pad}
\alias{pad}
\title{Pad images}
\usage{
pad(stimuli, top = 10, right = top, bottom = top, left = right, ...)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{top, right, bottom, left}{number of pixels or proportion (<1) to pad each side}

\item{...}{additional arguments to pass to \code{\link[=crop]{crop()}}}
}
\value{
list of stimuli
}
\description{
Add padding to sides of stimuli. This is a convenience function to calculate offsets for \code{\link[=crop]{crop()}}.
}
\details{
The value for top is copied to bottom and right, and the value for right is copied to left, so setting only top produces a consistent border, while setting just top and right sets different borders for top-bottom and right-left. (This convention will be familiar if you use CSS.)

Padding size values are interpreted as a proportion of width or height if less than  1.
}
\examples{
stimuli <- demo_stim()

# default 10-pixel padding
pad(stimuli, fill = "dodgerblue")

\donttest{
# change pad width and set fill
pad(stimuli, 2, fill = "dodgerblue")

# set top border to 10\% height
# different colour for each image
pad(stimuli, 0.1, 1, 1, 1,
    fill = c("hotpink", "dodgerblue"))
}
}
\seealso{
Stimulus manipulation functions
\code{\link{align}()},
\code{\link{crop_tem}()},
\code{\link{crop}()},
\code{\link{greyscale}()},
\code{\link{horiz_eyes}()},
\code{\link{image_func}()},
\code{\link{mask_oval}()},
\code{\link{mask}()},
\code{\link{mirror}()},
\code{\link{resize}()},
\code{\link{rotate}()},
\code{\link{to_size}()}
}
\concept{manipulators}
